package com.qboxus.tictic.activitesfragments.profile.settings

import android.content.Intent
import android.os.Bundle
import android.view.View
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.ViewModelProvider
import com.qboxus.tictic.R
import com.qboxus.tictic.activitesfragments.accounts.AccountUtils.removeMultipleAccount
import com.qboxus.tictic.activitesfragments.accounts.AccountUtils.setUpExistingAccountLogin
import com.qboxus.tictic.activitesfragments.accounts.LoginActivity
import com.qboxus.tictic.activitesfragments.accounts.ManageAccountsFragment
import com.qboxus.tictic.apiclasses.ApiResponce
import com.qboxus.tictic.databinding.ActivityDeleteAccountBinding
import com.qboxus.tictic.mainmenu.MainMenuActivity
import com.qboxus.tictic.repositories.UserRepository
import com.qboxus.tictic.simpleclasses.AppCompatLocaleActivity
import com.qboxus.tictic.simpleclasses.Dialogs.showDoubleButtonAlert
import com.qboxus.tictic.simpleclasses.Functions.getSharedPreference
import com.qboxus.tictic.simpleclasses.Functions.hideSoftKeyboard
import com.qboxus.tictic.simpleclasses.Functions.setLocale
import com.qboxus.tictic.simpleclasses.Functions.showToast
import com.qboxus.tictic.simpleclasses.Variables
import com.qboxus.tictic.viewModels.DeleteAccountFactory
import com.qboxus.tictic.viewModels.DeleteAccountViewModel
import com.google.android.gms.auth.api.signin.GoogleSignIn
import com.google.android.gms.auth.api.signin.GoogleSignInOptions
import io.paperdb.Paper

class DeleteAccountActivity : AppCompatLocaleActivity(), View.OnClickListener {

    lateinit var binding:ActivityDeleteAccountBinding

    lateinit var viewModel: DeleteAccountViewModel
    private val userRepository = UserRepository()


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setLocale(
            getSharedPreference(this@DeleteAccountActivity).getString(
                Variables.APP_LANGUAGE_CODE,
                Variables.DEFAULT_LANGUAGE_CODE
            ), this, javaClass, false
        )
        binding=DataBindingUtil.setContentView(this,R.layout.activity_delete_account)

        val viewModelProviderFactory = DeleteAccountFactory(this,userRepository)
        viewModel = ViewModelProvider(this,viewModelProviderFactory)[DeleteAccountViewModel::class.java]
        binding.viewModel=viewModel
        binding.lifecycleOwner = this


        InitControl()
        setObserver()

    }



    private fun InitControl() {
        binding.tvDeleteTitle.setText("""${getString(R.string.delete_account)}
    ${getSharedPreference(this@DeleteAccountActivity).getString(Variables.U_NAME, "")}?
    """.trimIndent()
        )
        binding.goBack.setOnClickListener(this)
        binding.deleteAccount.setOnClickListener(this)
    }


    fun setObserver(){
        viewModel.deleteUserLiveData.observe(this,{
            when(it){
                is ApiResponce.Success ->{
                    it.data?.let {
                        if (it != null) {
                            removePreferenceData()

                        }
                    }
                }
                is ApiResponce.Error ->{
                    showToast(this@DeleteAccountActivity, it.message)

                }
                else -> {

                }
            }
        })

    }




    override fun onClick(view: View) {
        when (view.id) {
            R.id.goBack -> {
                super@DeleteAccountActivity.onBackPressed()
            }

            R.id.deleteAccount -> {
                logoutProceed()
            }
        }
    }

    private fun logoutProceed() {
        if (Paper.book(Variables.MultiAccountKey).allKeys.size > 1) {
            showDoubleButtonAlert(
                this@DeleteAccountActivity,
                getString(R.string.are_you_sure_to_delete_account),
                "",
                getString(R.string.delete_account),
                getString(R.string.switch_account), true
            ) { bundle ->
                if (bundle.getBoolean("isShow", false)) {
                    openManageMultipleAccounts()
                } else {
                    viewModel.deleteUserAccount()
                }
            }
        }
        else {
            showDoubleButtonAlert(
                this@DeleteAccountActivity,
                getString(R.string.are_you_sure_to_delete_account),
                "",
                getString(R.string.cancel_),
                getString(R.string.delete_account), true
            ) { bundle ->
                if (bundle.getBoolean("isShow", false)) {
                    viewModel.deleteUserAccount()
                }
            }
        }
    }

    private fun removePreferenceData() {
        Paper.book(Variables.PrivacySetting).destroy()
        val gso = GoogleSignInOptions.Builder(GoogleSignInOptions.DEFAULT_SIGN_IN).build()
        val googleSignInClient = GoogleSignIn.getClient(this@DeleteAccountActivity, gso)
        googleSignInClient.signOut()
        removeMultipleAccount(this@DeleteAccountActivity)
        val editor = getSharedPreference(this@DeleteAccountActivity).edit()
        editor.clear()
        editor.commit()
        setUpExistingAccountLogin(this@DeleteAccountActivity)
        val intent = Intent(this@DeleteAccountActivity, MainMenuActivity::class.java)
        intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TASK or Intent.FLAG_ACTIVITY_NEW_TASK or Intent.FLAG_ACTIVITY_CLEAR_TOP)
        startActivity(intent)
    }

    private fun openManageMultipleAccounts() {
        val f = ManageAccountsFragment { bundle ->
            if (bundle.getBoolean("isShow", false)) {
                hideSoftKeyboard(this@DeleteAccountActivity)
                val intent = Intent(this@DeleteAccountActivity, LoginActivity::class.java)
                startActivity(intent)
                overridePendingTransition(R.anim.in_from_bottom, R.anim.out_to_top)
            }
        }
        f.show(supportFragmentManager, "")
    }
}